﻿
//
// remove all materials from selected object
//

function UndoableMaterialChange(child) {
    this._currentChild = child

    this.getName = function () {
        var IDS_MreUndoTriangulateRemoveMaterials = 154;
        return services.strings.getStringFromId(IDS_MreUndoTriangulateRemoveMaterials);
    }

    this.onDo = function () {

        this._oldMaterials = new Array();
        this._oldMaterialIndices = new Array();

        this._materialList = this._currentChild.behavior.materials;

        if (this._materialList != null && this._materialList.elementCount > 0) {
            // loop over all materials
            for (var j = 0; j < this._materialList.elementCount; j++) {

                var currentMaterial = this._materialList.getElement(j);
                this._oldMaterials.push(currentMaterial);
            }
            this._materialList.removeAll();

            var material = services.effects.createEffectInstance("Lambert");
            material.name = "Default - Lambert";

            var enableInPropWindow = 0x8;

            // set up the color traits
            var diffuseColorTrait = material.getOrCreateTrait("MaterialDiffuse", "float4", enableInPropWindow);
            diffuseColorTrait.value = [1, 1, 1, 1];

            var ambientColorTrait = material.getOrCreateTrait("MaterialAmbient", "float4", enableInPropWindow);
            ambientColorTrait.value = [1, 1, 1, 1]

            this._materialList.append(material);
        }

        // if the current child is a mesh get it's geometry and reset the polygon material indices
        if (this._currentChild.typeId == "Microsoft.VisualStudio.3D.Mesh") {
            var geom = this._currentChild.getTrait("Geometry").value;

            for (var k = 0; k < geom.polygonCount; k++) {
                var currentMaterialIndex = geom.getPolygonMaterialIndex(k);
                this._oldMaterialIndices.push(currentMaterialIndex);
                this._materialIndex = geom.setPolygonMaterialIndex(k, 0);
            }

            this._currentChild.behavior.recomputeCachedGeometry();
        }
    }

    this.onUndo = function () {

        this._materialList = this._currentChild.behavior.materials;
        this._materialList.removeAll();

        if (this._materialList != null && this._oldMaterials.length > 0) {
            // restore the materials
            for (var j = 0; j < this._oldMaterials.length; j++) {
                var prevMaterial = this._oldMaterials[j];
                this._materialList.append(prevMaterial);
            }
        }

        // restore the indices
        if (this._currentChild.typeId == "Microsoft.VisualStudio.3D.Mesh") {
            var geom = this._currentChild.getTrait("Geometry").value;
            for (var k = 0; k < this._oldMaterialIndices.length; k++) {
                var previousIndex = this._oldMaterialIndices[k];
                this._materialIndex = geom.setPolygonMaterialIndex(k, previousIndex);
            }

            this._currentChild.behavior.recomputeCachedGeometry();
        }
    }
}

function UndoableMultipleMaterialChange(targets) {
    this.getName = function () {
        var IDS_MreUndoTriangulateRemoveMaterials = 154;
        return services.strings.getStringFromId(IDS_MreUndoTriangulateRemoveMaterials);
    }
    this._undoableActions = [];
    this._counter = 0;
    this._targets = targets;

    for (var i = 0; i < this._targets.length; i++) {
        var element = this._targets[i];
        // loop over all children of selected element, looking
        // for children that have behaviors with valid list of materials
        for (var j = 0; j < element.childCount; j++) {
            // get child and its materials
            var child = element.getChild(j);
            this._undoableActions[this._counter] = new UndoableMaterialChange(child);
            this._counter++;
        }
    }

    this.onDo = function () {
        
        for (var i = 0; i < this._counter; i++) {
            this._undoableActions[i].onDo();
        }

        document.refreshPropertyWindow();
    }

    this.onUndo = function () {
        for (var i = 0; i < this._counter; i++) {
                this._undoableActions[i].onUndo();
            }

        document.refreshPropertyWindow();
    }
}

var targets = [];

// we might not have command args
try{
    if (commandArgs != null) {
        targets.push(commandArgs);
    }
}
catch (err) {}

var selectedElementCount = services.selection.count;
for (var i = 0; i < selectedElementCount; i++) {

    var selectedElement = services.selection.getElement(i);
    targets.push(selectedElement);
}

undoableItem = new UndoableMultipleMaterialChange(targets);
undoableItem.onDo();
services.undoService.addUndoableItem(undoableItem);

// SIG // Begin signature block
// SIG // MIIkCwYJKoZIhvcNAQcCoIIj/DCCI/gCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // qjwmlhUFvGFZ2675+8OeJm24rLJydeyd+09KhqKXCECg
// SIG // gg2TMIIGETCCA/mgAwIBAgITMwAAAI6HkaRXGl/KPgAA
// SIG // AAAAjjANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDExMB4XDTE2MTExNzIyMDkyMVoX
// SIG // DTE4MDIxNzIyMDkyMVowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBANCH1EIrfp3ZxnrUosPjFZLS
// SIG // U52VF8lSNvpUv6sQr+nJ58wmU8PCc79t1gDlANzpamc0
// SIG // MPYWF7QBpZV8i7mkLOaLO3n2Iwx5j/NS30ABHMLGA53r
// SIG // Wc9z6dhxOZvwziVZLdLJWwrvftYyDl10EgTsngRTpmsC
// SIG // Z/hNWYt34Csh4O/ApEUSzwN7A8Y5w9Qi3FVcd0L/nLLl
// SIG // VWdoui12an9mU0fVRwrMON6Ne5cZfYLQJviljuWh8F5k
// SIG // EOT56yfG8uAI0A3yZ8DY8i/7idoV+a4PPgCXB9ELPnDU
// SIG // d6tyeEGYB7gXzKKxX+y981Bno9eU8NKLVY9TppWT5rJm
// SIG // z8k3aORjx88CAwEAAaOCAYAwggF8MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjdMCAEGCCsGAQUFBwMDMB0GA1UdDgQWBBSr
// SIG // yNbtshXSqo7xzO1sOPdFStCKuzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwMDEy
// SIG // K2IwNTBjNmU3LTc2NDEtNDQxZi1iYzRhLTQzNDgxZTQx
// SIG // NWQwODAfBgNVHSMEGDAWgBRIbmTlUAXTgqoXNzcitW2o
// SIG // ynUClTBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NybC9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3JsMGEGCCsGAQUF
// SIG // BwEBBFUwUzBRBggrBgEFBQcwAoZFaHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraW9wcy9jZXJ0cy9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3J0MAwGA1UdEwEB
// SIG // /wQCMAAwDQYJKoZIhvcNAQELBQADggIBAESJAqxpU/PE
// SIG // trvUjGBT58psqElpZr6lmkGZOtid0lcCUWr6v5uW26Ym
// SIG // fQlW6NztJXV6pUdSqB5LFlPz7g+awwSVKcGChKRWMfyg
// SIG // ipGVtb9azqkBH2RGoebK8dd0e7+SCFFefDMCXlE7m+XY
// SIG // Ll8CTAmcGkPace3k2eei2nQsF63lDLUY9VQJ1L4cc80g
// SIG // e6T6yNvY2zqu+pDFo72VZa5GLVcpWNaS8GzaY/GPM6J+
// SIG // OHZe3fM17ayaO2KB0E4ZfEh8sAuPOMwtvNU5ZamVwQPi
// SIG // ksm5q9JXCqrcUgsuViej4piXV468qVluJJKOguIJc4LZ
// SIG // NYPMn3/RBI6IuOKag1iw1JrmMfqUR459puJOefPY02oz
// SIG // FlBw8UK7mAnp/8yVVVsIv5JSqAjE8ejx/0DX+Zo2nf26
// SIG // kIXSVT5QrUYf7yUMuJ46SARj73iYol0DDQLY3CCr5la1
// SIG // 3u8WZsPXVYIeT4J4yZ5UGhBgtxerQBORrrAZwZozne4y
// SIG // cs1lzE9GmC0PUWAefPv+2+gHeQf3oTM4/gma2497tjq9
// SIG // hYa4zLx9ATC3ex2pXRu9zE0X925HM9VA32rKLlG4tbnP
// SIG // wwTTO+Xj6RCM66e63qQuM2opLxRK6h7BIjg1BYXvwgQA
// SIG // DWvB2JYUSBWvflKwuGDEUrVKgreFKgBJKiaDJ1pB3r3V
// SIG // Zkm8C5x4cAm8MIIHejCCBWKgAwIBAgIKYQ6Q0gAAAAAA
// SIG // AzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2Vy
// SIG // dGlmaWNhdGUgQXV0aG9yaXR5IDIwMTEwHhcNMTEwNzA4
// SIG // MjA1OTA5WhcNMjYwNzA4MjEwOTA5WjB+MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29k
// SIG // ZSBTaWduaW5nIFBDQSAyMDExMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAq/D6chAcLq3YbqqCEE00
// SIG // uvK2WCGfQhsqa+laUKq4BjgaBEm6f8MMHt03a8YS2Avw
// SIG // OMKZBrDIOdUBFDFC04kNeWSHfpRgJGyvnkmc6Whe0t+b
// SIG // U7IKLMOv2akrrnoJr9eWWcpgGgXpZnboMlImEi/nqwhQ
// SIG // z7NEt13YxC4Ddato88tt8zpcoRb0RrrgOGSsbmQ1eKag
// SIG // Yw8t00CT+OPeBw3VXHmlSSnnDb6gE3e+lD3v++MrWhAf
// SIG // TVYoonpy4BI6t0le2O3tQ5GD2Xuye4Yb2T6xjF3oiU+E
// SIG // GvKhL1nkkDstrjNYxbc+/jLTswM9sbKvkjh+0p2ALPVO
// SIG // VpEhNSXDOW5kf1O6nA+tGSOEy/S6A4aN91/w0FK/jJSH
// SIG // vMAhdCVfGCi2zCcoOCWYOUo2z3yxkq4cI6epZuxhH2rh
// SIG // KEmdX4jiJV3TIUs+UsS1Vz8kA/DRelsv1SPjcF0PUUZ3
// SIG // s/gA4bysAoJf28AVs70b1FVL5zmhD+kjSbwYuER8ReTB
// SIG // w3J64HLnJN+/RpnF78IcV9uDjexNSTCnq47f7Fufr/zd
// SIG // sGbiwZeBe+3W7UvnSSmnEyimp31ngOaKYnhfsi+E11ec
// SIG // XL93KCjx7W3DKI8sj0A3T8HhhUSJxAlMxdSlQy90lfdu
// SIG // +HggWCwTXWCVmj5PM4TasIgX3p5O9JawvEagbJjS4NaI
// SIG // jAsCAwEAAaOCAe0wggHpMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBRIbmTlUAXTgqoXNzcitW2oynUClTAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
// SIG // gBRyLToCMZBDuRQFTuHqp8cx0SOJNDBaBgNVHR8EUzBR
// SIG // ME+gTaBLhklodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXQyMDEx
// SIG // XzIwMTFfMDNfMjIuY3JsMF4GCCsGAQUFBwEBBFIwUDBO
// SIG // BggrBgEFBQcwAoZCaHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXQyMDExXzIw
// SIG // MTFfMDNfMjIuY3J0MIGfBgNVHSAEgZcwgZQwgZEGCSsG
// SIG // AQQBgjcuAzCBgzA/BggrBgEFBQcCARYzaHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraW9wcy9kb2NzL3ByaW1h
// SIG // cnljcHMuaHRtMEAGCCsGAQUFBwICMDQeMiAdAEwAZQBn
// SIG // AGEAbABfAHAAbwBsAGkAYwB5AF8AcwB0AGEAdABlAG0A
// SIG // ZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4ICAQBn8oal
// SIG // mOBUeRou09h0ZyKbC5YR4WOSmUKWfdJ5DJDBZV8uLD74
// SIG // w3LRbYP+vj/oCso7v0epo/Np22O/IjWll11lhJB9i0ZQ
// SIG // VdgMknzSGksc8zxCi1LQsP1r4z4HLimb5j0bpdS1HXeU
// SIG // OeLpZMlEPXh6I/MTfaaQdION9MsmAkYqwooQu6SpBQyb
// SIG // 7Wj6aC6VoCo/KmtYSWMfCWluWpiW5IP0wI/zRive/DvQ
// SIG // vTXvbiWu5a8n7dDd8w6vmSiXmE0OPQvyCInWH8MyGOLw
// SIG // xS3OW560STkKxgrCxq2u5bLZ2xWIUUVYODJxJxp/sfQn
// SIG // +N4sOiBpmLJZiWhub6e3dMNABQamASooPoI/E01mC8Cz
// SIG // TfXhj38cbxV9Rad25UAqZaPDXVJihsMdYzaXht/a8/jy
// SIG // FqGaJ+HNpZfQ7l1jQeNbB5yHPgZ3BtEGsXUfFL5hYbXw
// SIG // 3MYbBL7fQccOKO7eZS/sl/ahXJbYANahRr1Z85elCUtI
// SIG // EJmAH9AAKcWxm6U/RXceNcbSoqKfenoi+kiVH6v7RyOA
// SIG // 9Z74v2u3S5fi63V4GuzqN5l5GEv/1rMjaHXmr/r8i+sL
// SIG // gOppO6/8MO0ETI7f33VtY5E90Z1WTk+/gFcioXgRMiF6
// SIG // 70EKsT/7qMykXcGhiJtXcVZOSEXAQsmbdlsKgEhr/Xmf
// SIG // wb1tbWrJUnMTDXpQzTGCFdAwghXMAgEBMIGVMH4xCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29m
// SIG // dCBDb2RlIFNpZ25pbmcgUENBIDIwMTECEzMAAACOh5Gk
// SIG // Vxpfyj4AAAAAAI4wDQYJYIZIAWUDBAIBBQCggb4wGQYJ
// SIG // KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
// SIG // NwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkE
// SIG // MSIEIMcy5x34s1hqTGZgP162dWuO9mcDnXz7gINUcnj3
// SIG // Yb0NMFIGCisGAQQBgjcCAQwxRDBCoCiAJgBSAGUAbQBv
// SIG // AHYAZQAgAE0AYQB0AGUAcgBpAGEAbABzAC4AagBzoRaA
// SIG // FGh0dHA6Ly9taWNyb3NvZnQuY29tMA0GCSqGSIb3DQEB
// SIG // AQUABIIBAKpn2DjsQr5slxQXEDj2WBKfVt3Zy8sshpDK
// SIG // Y/oYMbGL23ShLlLfsVLLx6ESiwCY7YXqSKr38yE/ko5l
// SIG // 7AtULwyrwvhnPsECi3tFRxF2UidThhLseN+0AUfmTSPc
// SIG // zmpEykSRg4ZHkxoraMuJYIhjvUHmcr/rw8V7qejkvKaz
// SIG // eH6FNi/F9jyOHQb4MzioRJd9PxZ5X0tdTj0+FINR5Z6L
// SIG // W6NP6NRxLSZVoQq5VP8wh2YhNf0qXtM3u0ca+QAAg1ib
// SIG // WrXdrIBFtLWinkkVAuvlj/EWh3eT9BOAa5qQnJVCEJz0
// SIG // H/GVG7JE/olY0im8TTBnLjZKef9eZW/dp0EJH0rGiyCh
// SIG // ghNKMIITRgYKKwYBBAGCNwMDATGCEzYwghMyBgkqhkiG
// SIG // 9w0BBwKgghMjMIITHwIBAzEPMA0GCWCGSAFlAwQCAQUA
// SIG // MIIBPQYLKoZIhvcNAQkQAQSgggEsBIIBKDCCASQCAQEG
// SIG // CisGAQQBhFkKAwEwMTANBglghkgBZQMEAgEFAAQgTGM1
// SIG // qmDDjUeS5NAVkuABmu6GKQo8rKOpYgyCeD55DzsCBliv
// SIG // sjm07hgTMjAxNzAzMDQyMzI0MDcuNzQ4WjAHAgEBgAIB
// SIG // 9KCBuaSBtjCBszELMAkGA1UEBhMCVVMxEzARBgNVBAgT
// SIG // Cldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAc
// SIG // BgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjENMAsG
// SIG // A1UECxMETU9QUjEnMCUGA1UECxMebkNpcGhlciBEU0Ug
// SIG // RVNOOkI4RUMtMzBBNC03MTQ0MSUwIwYDVQQDExxNaWNy
// SIG // b3NvZnQgVGltZS1TdGFtcCBTZXJ2aWNloIIOzTCCBnEw
// SIG // ggRZoAMCAQICCmEJgSoAAAAAAAIwDQYJKoZIhvcNAQEL
// SIG // BQAwgYgxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNo
// SIG // aW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQK
// SIG // ExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xMjAwBgNVBAMT
// SIG // KU1pY3Jvc29mdCBSb290IENlcnRpZmljYXRlIEF1dGhv
// SIG // cml0eSAyMDEwMB4XDTEwMDcwMTIxMzY1NVoXDTI1MDcw
// SIG // MTIxNDY1NVowfDELMAkGA1UEBhMCVVMxEzARBgNVBAgT
// SIG // Cldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAc
// SIG // BgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQG
// SIG // A1UEAxMdTWljcm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIw
// SIG // MTAwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
// SIG // AQCpHQ28dxGKOiDs/BOX9fp/aZRrdFQQ1aUKAIKF++18
// SIG // aEssX8XD5WHCdrc+Zitb8BVTJwQxH0EbGpUdzgkTjnxh
// SIG // MFmxMEQP8WCIhFRDDNdNuDgIs0Ldk6zWczBXJoKjRQ3Q
// SIG // 6vVHgc2/JGAyWGBG8lhHhjKEHnRhZ5FfgVSxz5NMksHE
// SIG // pl3RYRNuKMYa+YaAu99h/EbBJx0kZxJyGiGKr0tkiVBi
// SIG // sV39dx898Fd1rL2KQk1AUdEPnAY+Z3/1ZsADlkR+79BL
// SIG // /W7lmsqxqPJ6Kgox8NpOBpG2iAg16HgcsOmZzTznL0S6
// SIG // p/TcZL2kAcEgCZN4zfy8wMlEXV4WnAEFTyJNAgMBAAGj
// SIG // ggHmMIIB4jAQBgkrBgEEAYI3FQEEAwIBADAdBgNVHQ4E
// SIG // FgQU1WM6XIoxkPNDe3xGG8UzaFqFbVUwGQYJKwYBBAGC
// SIG // NxQCBAweCgBTAHUAYgBDAEEwCwYDVR0PBAQDAgGGMA8G
// SIG // A1UdEwEB/wQFMAMBAf8wHwYDVR0jBBgwFoAU1fZWy4/o
// SIG // olxiaNE9lJBb186aGMQwVgYDVR0fBE8wTTBLoEmgR4ZF
// SIG // aHR0cDovL2NybC5taWNyb3NvZnQuY29tL3BraS9jcmwv
// SIG // cHJvZHVjdHMvTWljUm9vQ2VyQXV0XzIwMTAtMDYtMjMu
// SIG // Y3JsMFoGCCsGAQUFBwEBBE4wTDBKBggrBgEFBQcwAoY+
// SIG // aHR0cDovL3d3dy5taWNyb3NvZnQuY29tL3BraS9jZXJ0
// SIG // cy9NaWNSb29DZXJBdXRfMjAxMC0wNi0yMy5jcnQwgaAG
// SIG // A1UdIAEB/wSBlTCBkjCBjwYJKwYBBAGCNy4DMIGBMD0G
// SIG // CCsGAQUFBwIBFjFodHRwOi8vd3d3Lm1pY3Jvc29mdC5j
// SIG // b20vUEtJL2RvY3MvQ1BTL2RlZmF1bHQuaHRtMEAGCCsG
// SIG // AQUFBwICMDQeMiAdAEwAZQBnAGEAbABfAFAAbwBsAGkA
// SIG // YwB5AF8AUwB0AGEAdABlAG0AZQBuAHQALiAdMA0GCSqG
// SIG // SIb3DQEBCwUAA4ICAQAH5ohRDeLG4Jg/gXEDPZ2joSFv
// SIG // s+umzPUxvs8F4qn++ldtGTCzwsVmyWrf9efweL3HqJ4l
// SIG // 4/m87WtUVwgrUYJEEvu5U4zM9GASinbMQEBBm9xcF/9c
// SIG // +V4XNZgkVkt070IQyK+/f8Z/8jd9Wj8c8pl5SpFSAK84
// SIG // Dxf1L3mBZdmptWvkx872ynoAb0swRCQiPM/tA6WWj1kp
// SIG // vLb9BOFwnzJKJ/1Vry/+tuWOM7tiX5rbV0Dp8c6ZZpCM
// SIG // /2pif93FSguRJuI57BlKcWOdeyFtw5yjojz6f32WapB4
// SIG // pm3S4Zz5Hfw42JT0xqUKloakvZ4argRCg7i1gJsiOCC1
// SIG // JeVk7Pf0v35jWSUPei45V3aicaoGig+JFrphpxHLmtgO
// SIG // R5qAxdDNp9DvfYPw4TtxCd9ddJgiCGHasFAeb73x4QDf
// SIG // 5zEHpJM692VHeOj4qEir995yfmFrb3epgcunCaw5u+zG
// SIG // y9iCtHLNHfS4hQEegPsbiSpUObJb2sgNVZl6h3M7COaY
// SIG // LeqN4DMuEin1wC9UJyH3yKxO2ii4sanblrKnQqLJzxlB
// SIG // TeCG+SqaoxFmMNO7dDJL32N79ZmKLxvHIa9Zta7cRDyX
// SIG // UHHXodLFVeNp3lfB0d4wwP3M5k37Db9dT+mdHhk4L7zP
// SIG // WAUu7w2gUDXa7wknHNWzfjUeCLraNtvTX4/edIhJEjCC
// SIG // BNowggPCoAMCAQICEzMAAACfZ/K1qCMGW3sAAAAAAJ8w
// SIG // DQYJKoZIhvcNAQELBQAwfDELMAkGA1UEBhMCVVMxEzAR
// SIG // BgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1v
// SIG // bmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlv
// SIG // bjEmMCQGA1UEAxMdTWljcm9zb2Z0IFRpbWUtU3RhbXAg
// SIG // UENBIDIwMTAwHhcNMTYwOTA3MTc1NjQ3WhcNMTgwOTA3
// SIG // MTc1NjQ3WjCBszELMAkGA1UEBhMCVVMxEzARBgNVBAgT
// SIG // Cldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAc
// SIG // BgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjENMAsG
// SIG // A1UECxMETU9QUjEnMCUGA1UECxMebkNpcGhlciBEU0Ug
// SIG // RVNOOkI4RUMtMzBBNC03MTQ0MSUwIwYDVQQDExxNaWNy
// SIG // b3NvZnQgVGltZS1TdGFtcCBTZXJ2aWNlMIIBIjANBgkq
// SIG // hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAuQjxI5zdxAIv
// SIG // AoWhoyeXZPkDnBJUP1OCWrg+631uGMVywSfVcCkM8JZL
// SIG // 1o+ExxY5Yp77sQ0jhKLjMPfSdVAL09nQ0O76kr1dXzc5
// SIG // +MZyEWQrM4FF106GmxCTEWAwXdF8tM1cASp9+c1pF5fC
// SIG // 1VSSIYQm9boqYAGLHM/Rp5RWYnowecmeaj5Mpl2hWXty
// SIG // DpNjosKjN78XquE5eaL8/df8reMe2YBrEv067neOMOA7
// SIG // lGPG3pkRqZ0SwYXZJZnrAfoOaD0bqJk/GDD6aM4PBF4v
// SIG // qPCHsfZeGy/OgUytIREzMgh/Z4kYAz0LQZHQFkfJG2LX
// SIG // tCovlNoK5Y+MzFMpdfgOWQIDAQABo4IBGzCCARcwHQYD
// SIG // VR0OBBYEFP2LGyLDfSNHdqYe3+Bm1FLptvmgMB8GA1Ud
// SIG // IwQYMBaAFNVjOlyKMZDzQ3t8RhvFM2hahW1VMFYGA1Ud
// SIG // HwRPME0wS6BJoEeGRWh0dHA6Ly9jcmwubWljcm9zb2Z0
// SIG // LmNvbS9wa2kvY3JsL3Byb2R1Y3RzL01pY1RpbVN0YVBD
// SIG // QV8yMDEwLTA3LTAxLmNybDBaBggrBgEFBQcBAQROMEww
// SIG // SgYIKwYBBQUHMAKGPmh0dHA6Ly93d3cubWljcm9zb2Z0
// SIG // LmNvbS9wa2kvY2VydHMvTWljVGltU3RhUENBXzIwMTAt
// SIG // MDctMDEuY3J0MAwGA1UdEwEB/wQCMAAwEwYDVR0lBAww
// SIG // CgYIKwYBBQUHAwgwDQYJKoZIhvcNAQELBQADggEBAGUQ
// SIG // wWxrzxUerw9INuvfLQu8AADmkWYaUJZluTEPZYyp8XTL
// SIG // x+eW+BvzvjPyzPxBnMHIKZjWMfIdNz3xl6TPsvZjlIA1
// SIG // QhryPJTfpzrgKTl9jo972FQDVEb/XM/56rTzRyFQ8IXb
// SIG // N7OF/C7P05vShs7rgHBbQZmBhjPWGOyr4MGRIIFFXn2v
// SIG // IWnOApHCFYXyq5e0cOmKaInH52zZVlLARWT9BFjuku5S
// SIG // 9503w/kM24tppHDeglyzZbGHaNZLlPxjcl69SjcrdVO0
// SIG // c+LYgFYhKQQbtM6c0RRxRcMwZI55nbuS48XMqQNVu3O/
// SIG // ARV6mQauxnVb7XG4Ng9DVvcEwbwLv0ehggN2MIICXgIB
// SIG // ATCB46GBuaSBtjCBszELMAkGA1UEBhMCVVMxEzARBgNV
// SIG // BAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQx
// SIG // HjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEN
// SIG // MAsGA1UECxMETU9QUjEnMCUGA1UECxMebkNpcGhlciBE
// SIG // U0UgRVNOOkI4RUMtMzBBNC03MTQ0MSUwIwYDVQQDExxN
// SIG // aWNyb3NvZnQgVGltZS1TdGFtcCBTZXJ2aWNloiUKAQEw
// SIG // CQYFKw4DAhoFAAMVAGzTJwjy+dmoy/kZ3pJLSq3bGaPB
// SIG // oIHCMIG/pIG8MIG5MQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMQ0w
// SIG // CwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVyIE5U
// SIG // UyBFU046NTdGNi1DMUUwLTU1NEMxKzApBgNVBAMTIk1p
// SIG // Y3Jvc29mdCBUaW1lIFNvdXJjZSBNYXN0ZXIgQ2xvY2sw
// SIG // DQYJKoZIhvcNAQEFBQACBQDcZXDAMCIYDzIwMTcwMzA0
// SIG // MTY1ODQwWhgPMjAxNzAzMDUxNjU4NDBaMHQwOgYKKwYB
// SIG // BAGEWQoEATEsMCowCgIFANxlcMACAQAwBwIBAAICJiww
// SIG // BwIBAAICGQIwCgIFANxmwkACAQAwNgYKKwYBBAGEWQoE
// SIG // AjEoMCYwDAYKKwYBBAGEWQoDAaAKMAgCAQACAxbjYKEK
// SIG // MAgCAQACAwehIDANBgkqhkiG9w0BAQUFAAOCAQEAHBDO
// SIG // hvhP6bzlAZsnkisIuRdW1RORMCDGrOQVAiRBkjEGcKXj
// SIG // HwJoUbzKgiiEJbscUAwe+r09H5r+fGOwl/fCCjptqG4h
// SIG // 6bc2AZiK3YWS/7iv392L/SSIIGf/lUVhIMUDRO8tBkEW
// SIG // kS/w2pZGJJuTgPK4kv/L6c9S2doddFoOEJ/mnSuuy8Af
// SIG // +gxdk94wutzqDHEQCF5pU3P7mrYbMiuEi6oaOuZ0dCvp
// SIG // qFBExTfkG0p/TUKAu2OGT2pM6exu+ZD7wj4PUCKSfdAX
// SIG // 8PgMjvu2HE0kMaXvqUYPVssu+iEeUtgUK5rH7tgac0h9
// SIG // hUe64KiLOTe4B0ykoiXr06IlR+JQpzGCAvUwggLxAgEB
// SIG // MIGTMHwxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNo
// SIG // aW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQK
// SIG // ExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xJjAkBgNVBAMT
// SIG // HU1pY3Jvc29mdCBUaW1lLVN0YW1wIFBDQSAyMDEwAhMz
// SIG // AAAAn2fytagjBlt7AAAAAACfMA0GCWCGSAFlAwQCAQUA
// SIG // oIIBMjAaBgkqhkiG9w0BCQMxDQYLKoZIhvcNAQkQAQQw
// SIG // LwYJKoZIhvcNAQkEMSIEIJE/Kmv/wGjJ+pUGwQ6Ep77i
// SIG // vOKF7yDEvP+t44q9bhxBMIHiBgsqhkiG9w0BCRACDDGB
// SIG // 0jCBzzCBzDCBsQQUbNMnCPL52ajL+RnekktKrdsZo8Ew
// SIG // gZgwgYCkfjB8MQswCQYDVQQGEwJVUzETMBEGA1UECBMK
// SIG // V2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwG
// SIG // A1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSYwJAYD
// SIG // VQQDEx1NaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0EgMjAx
// SIG // MAITMwAAAJ9n8rWoIwZbewAAAAAAnzAWBBR2hP+sL1IG
// SIG // PGoYi7dSddiFLRwoNjANBgkqhkiG9w0BAQsFAASCAQCN
// SIG // nTuKVTtrCHYHHxgyPqHholhl8gPlWZRE8z02mDyL/J33
// SIG // RfOFssXTNsQDhBEzKVF99PV3h3omFQo6P9Tt4u4Rosgt
// SIG // oByh/KBsrpMwXG99Uf6WJs+ZyV4SaiCbTAe9QZp14BL6
// SIG // 9BH9SVoV5gRD5JwllR3xa+peEg33RjiybX13KUnJAv1p
// SIG // wf8SpB+K2NxTcz80A8Ge8TsCE5CAwZFtyw5nh7TFCFEQ
// SIG // y6XuRk2oZPx+/UAFnaQLmCUTgbCREHq6sgfdAbltJt+Z
// SIG // juyOEWmb/Lz4C9S5dcNPJxDZY4YHjG6Vf8xSc3J2hjSq
// SIG // SS+d+Q0Cm17tYmEsInEpNamUgHt6w9oP
// SIG // End signature block
